Attribute VB_Name = "MdlGraph"
Option Explicit

Const GRAPH_Y_POSI_OFFSET As Single = 0.8
Const CENTER_OFFSET As Single = 50
Const GRAPH_Y_RATIO As Single = 1.054545
Const pi As Double = 3.14159265358979

Public Const COLOR_DARKSLATEGRAY As Long = 5197615  ' RGB(&H2F, &H4F, &H4F)
Public Const COLOR_SALMON As Long = 7504122         ' RGB(&HFA, &H80, &H72)
Public Const COLOR_GRAY As Long = 8421504           ' RGB(&H80, &H80, &H80)
Public Const COLOR_DODGERBLUE As Long = 16748574    ' RGB(&H1E, &H90,&HFF)
Public Const COLOR_DEEPPINK As Long = 9639167       ' RGB(&HFF, &H14, &H93)
Public Const COLOR_ORANGEREAD As Long = 42495       ' RGB(&HFF, &HA5, &H00)
Public Const COLOR_GRID_LOGMAG As Long = COLOR_DARKSLATEGRAY
Public Const COLOR_BOLD_GRID_LOGMAG As Long = COLOR_GRAY
Public Const COLOR_WAVE_LOGMAG As Long = vbYellow
Public Const COLOR_REFL_LOGMAG As Long = COLOR_WAVE_LOGMAG

Public Const COLOR_WAVE_PHASE As Long = vbGreen
Public Const COLOR_REFL_PHASE As Long = COLOR_WAVE_PHASE

Public Const COLOR_MARK_POLAR_SMITH As Long = vbRed

Public Const COLOR_WAVE_POLAR As Long = COLOR_SALMON
Public Const COLOR_GRID_POLAR As Long = vbWhite
Public Const COLOR_BOLD_GRID_POLAR As Long = COLOR_DARKSLATEGRAY

Public Const COLOR_WAVE_SMITH As Long = COLOR_DODGERBLUE
Public Const COLOR_GRID_SMITH As Long = COLOR_GRAY
Public Const COLOR_BOLD_GRID_SMITH As Long = vbWhite

Public Const COLOR_WAVE_DELAY As Long = COLOR_DEEPPINK
Public Const COLOR_REFL_DELAY As Long = COLOR_WAVE_DELAY
Public Const COLOR_GRID_DELAY As Long = COLOR_DARKSLATEGRAY
Public Const COLOR_BOLD_GRID_DELAY As Long = COLOR_GRAY

Public Const COLOR_WAVE___SWR As Long = COLOR_ORANGEREAD
Public Const COLOR_REFL___SWR As Long = COLOR_WAVE___SWR
Public Const COLOR_GRID___SWR As Long = COLOR_DARKSLATEGRAY
Public Const COLOR_BOLD_GRID___SWR As Long = COLOR_GRAY

Public Const COLOR_WAVE__REAL As Long = &H7FFF00        'springgreen
Public Const COLOR_REFL__REAL As Long = COLOR_WAVE__REAL
Public Const COLOR_GRID__REAL As Long = COLOR_DARKSLATEGRAY
Public Const COLOR_BOLD_GRID__REAL As Long = COLOR_GRAY

Public Const COLOR_WAVE__IMAG As Long = &HFFFF00        'aqua
Public Const COLOR_REFL__IMAG As Long = COLOR_WAVE__IMAG
Public Const COLOR_GRID__IMAG As Long = COLOR_DARKSLATEGRAY
Public Const COLOR_BOLD_GRID__IMAG As Long = COLOR_GRAY

Public Const MkrfGHzfkHz$ = "#0.000000000000#"         ' 0.000 001 GHz = 1kHz resolution
'Public Const MkrfMHzfkHz$ = "#0.000000000#"            ' 0.001 MHz     = 1kHz resolution
Public Const MkrfMHzfkHz$ = "0000.0"            ' 0.1 MHz     = 1kHz resolution

'************************************************************************
' Auto XP[{^
'         ByRef mx As Double   : ől
'         ByRef mn As Double   : ŏl
'         ByRef scl As Scale_t : XP[l
'************************************************************************
Public Sub auto_scale(ByRef mx As Double, ByRef mn As Double, ByRef scl As Scale_t)
    Dim div As Double
    Dim divs As String
    Dim head As String
    Dim rfv As Double

    div = (mx - mn) / 9
    If div < 0.001 Then '=== Does not perform scaling when value is less than 0.001 ===
        div = 0.001
    Else
        div = div * 1000 '<-- Multiply the value by 1000 temporarily.
        divs = CStr(div)
        If CDbl(Mid(divs, 2)) > 0 Then 'When the second and subsequent digits are other than 0.
            divs = CStr(CDbl(divs) - CDbl(Mid(divs, 2))) 'Clear the second and subsequent digits from the beginning to 0.
            divs = (CDbl(Mid(divs, 1, 1)) + 1) & Mid(divs, 2) 'Round-up the first digit.
        End If
        head = Mid(divs, 1, 1) 'Take out the first character.
        If CDbl(head) > 5 Then '--- Convert the value to 1/2/5 step. ---
            head = "10" '        V
        ElseIf CDbl(head) > 2 Then  '        V
            head = "5" '        V
        ElseIf CDbl(head) > 1 Then  '        V
            head = "2" '        V
        End If '        V
        divs = head & Mid(divs, 2)
        div = CSng(divs) / 1000 '<-- Clear the multiplication by 1000.
    End If
    scl.div = div
    rfv = CSng(CLng((mx + mn) / 2 / div)) * div
    scl.ref = rfv + ((scl.pos - 50) * div) / 10

End Sub

Function chg_unit_value(ByRef dt As Double, ByRef unit_dt As Double) As Double
    Dim d As Single

    d = dt
    unit_dt = Unit_s

    If d >= Unit_g Then
        d = dt * Multiple_g
        unit_dt = Unit_g
    ElseIf d >= Unit_mega Then
        d = dt * Multiple_mega
        unit_dt = Unit_mega
    ElseIf d >= Unit_k Then
        d = dt * Multiple_k
        unit_dt = Unit_k
    ElseIf d >= Unit_s Then
        d = dt
        unit_dt = Unit_s
    ElseIf d >= Unit_m Then
        d = dt * Multiple_m
        unit_dt = Unit_m
    ElseIf d >= Unit_u Then
        d = dt * Multiple_u
        unit_dt = Unit_u
    ElseIf d >= Unit_n Then
        d = dt * Multiple_n
        unit_dt = Unit_n
    ElseIf d >= Unit_p Then
        d = dt * Multiple_p
        unit_dt = Unit_p
    ElseIf d >= Unit_f Then
        d = dt * Multiple_f
        unit_dt = Unit_f
    End If

    chg_unit_value = d

End Function

Sub auto_scale2(ByRef mx As Double, ByRef mn As Double, ByRef scl As Scale_t)
    Dim unit_dt As Double
    Dim div As Double
    Dim divs As String
    Dim head As String
    Dim rfv As Double

    div = (mx - mn) / 9
    div = chg_unit_value(div, unit_dt)
    If div < 0.001 Then '=== Does not perform scaling when value is less than 0.001 ===
        div = 0.001
    Else
        div = div * 1000 '<-- Multiply the value by 1000 temporarily.
        divs = CStr(div)
        If CDbl(Mid(divs, 2)) > 0 Then 'When the second and subsequent digits are other than 0.
            divs = CStr(CDbl(divs) - CDbl(Mid(divs, 2))) 'Clear the second and subsequent digits from the beginning to 0.
            divs = (CDbl(Mid(divs, 1, 1)) + 1) & Mid(divs, 2) 'Round-up the first digit.
        End If
        head = Mid(divs, 1, 1) 'Take out the first character.
        If CDbl(head) > 5 Then '--- Convert the value to 1/2/5 step. ---
            head = "10" '        V
        ElseIf CDbl(head) > 2 Then  '        V
            head = "5" '        V
        ElseIf CDbl(head) > 1 Then  '        V
            head = "2" '        V
        End If '        V
        divs = head & Mid(divs, 2)
        div = CSng(divs) / 1000 '<-- Clear the multiplication by 1000.
    End If
    div = div * unit_dt
    scl.div = div
    rfv = CSng(CLng((mx + mn) / 2 / div)) * div
    scl.ref = rfv + ((scl.pos - 50) * div) / 10
End Sub

'***********************************************************************************
' Obh\
'***********************************************************************************
Private Sub grid_display(ByRef pic As PictureBox, GrphRectInf As struct_Rectangular_coordinate)
    Dim i As Integer
    
    With GrphRectInf
        pic.DrawStyle = 0  'Solid line specification
        '----------------------------------
        ' Grid display
        '----------------------------------
        For i = 1 To 9
            If i <> 5 And i <> 10 Then
                pic.PSet (.ViewX, .ViewY * (i + .VYoff))
                pic.Line -(.ViewX * 101, .ViewY * (i + .VYoff)), .Color1
                pic.PSet (.ViewX * (i * 10 + 1), .ViewY * .VYoff)
                pic.Line -(.ViewX * (i * 10 + 1), .ViewY * (10 + .VYoff)), .Color1
            End If
        Next i
    
        For i = 0 To 10 Step 5
            pic.PSet (.ViewX, .ViewY * (i + .VYoff))
            pic.Line -(.ViewX * 101, .ViewY * (i + .VYoff)), .Color2
            pic.PSet (.ViewX * (i * 10 + 1), .ViewY * .VYoff)
            pic.Line -(.ViewX * (i * 10 + 1), .ViewY * (10 + .VYoff)), .Color2
        Next i
    
        pic.Line -(.ViewX * 101, .ViewY * 10), .Color2  ' Because the end point is not displayed.
    End With
    
End Sub

'***********************************************************************************
' t@XE}[J\
'***********************************************************************************
Private Sub ref_mkr_display(ByRef pic As PictureBox, ByRef scl As Scale_t, GrphRectInf As struct_Rectangular_coordinate)
    Dim yy As Single
    
    With GrphRectInf
        '----------------------------------
        ' Reference mark  display
        '----------------------------------
        yy = .ViewY * (10 + .VYoff - scl.pos / 10)
        pic.PSet (.ViewX * 101, yy)
        pic.Line -(.ViewX * 103, yy - .ViewY * 0.15), .Color1
        pic.Line -(.ViewX * 103, yy + .ViewY * 0.15), .Color1
        pic.Line -(.ViewX * 101, yy), .Color1
    End With
End Sub


'***********************************************************************************
' XP[͈̓`FbN
'***********************************************************************************
Private Function SclLim(ByVal mx As Single, ByVal mn As Single, ByVal vy As Single, _
                        ByVal dy As Single, ByVal dt As Single) As Single
    Dim hh As Single
    Dim ym As Single
    Dim yn As Single

    '' Add a few dots to the upper and lower scale limits.
    hh = dy * (mx - mn)
    ym = hh * (-0.01)
    yn = hh * 1.01
    SclLim = dy * (mx - dt)
    If ym > SclLim Then
        SclLim = ym
    ElseIf SclLim > yn Then
        SclLim = yn
    End If
    SclLim = vy + SclLim

End Function

'***********************************************************************************
' g`\(W\)
'***********************************************************************************
Private Sub waveform_display(ByVal lngCh As Long, ByVal pic As PictureBox, ByRef scl As Scale_t, _
                GrphRectInf As struct_Rectangular_coordinate, ByRef Data() As Single)
    Dim Grefv, Gsdiv, Grefp, StepSdiv As Single
    Dim ss As Single
    Dim Gsmax, Gsmin As Single
    Dim DeltY As Single
    Dim x1, y1, x2, y2 As Single
    Dim x1_pre, y1_pre, x2_pre, y2_pre As Single
    Dim i As Integer
    Dim po As Long
    Dim Ydata1 As Single
    
    On Error GoTo ErrLogmagOverflow

    '----------------------------------
    '  waveform
    '----------------------------------
    With GrphRectInf
        Grefv = scl.ref
        Gsdiv = scl.div
        Grefp = scl.pos
        StepSdiv = Gsdiv / 10
        ss = Abs(100 - Grefp)
        Gsmax = Grefv + (ss * StepSdiv)
        Gsmin = Grefv - (Abs(100 - ss) * StepSdiv)
    
        'Calculating 
        ss = Gsmax - Gsmin
        If ss = 0 Then ss = Gsmin
        DeltY = (.ViewY * 10) / ss
        '
        Ydata1 = SclLim(Gsmax, Gsmin, .ViewY * .VYoff, DeltY, Data(0, lngCh))
        pic.PSet (.ViewX, Ydata1)
        i = 0
        For po = 0 To .points
            Ydata1 = SclLim(Gsmax, Gsmin, .ViewY * .VYoff, DeltY, Data(i, lngCh))
            pic.Line -(.DeltX * po + .ViewX, Ydata1), .Color1
            i = i + 1
        Next po
    End With
    
ErrLogmagEnd:
    On Error GoTo 0
    Exit Sub

ErrLogmagOverflow:
    MsgBox "Error Data Overflow" + vbCrLf + vbCrLf, vbOKOnly Or vbCritical
    GoTo ErrLogmagEnd

End Sub

'***********************************************************************************
' 
'     ByVal g As Graphics : Ot\ւ̃IuWFNg
'         ByRef points As Integer : |Cg
'         ByRef scl As Scale_t : XP[
'         ByRef p1 As Integer : Box(x1, y) }[J[\ʒu|Cg
'         ByRef p2 As Integer : Box(x2, y) }[J[\ʒu|Cg
'         ByVal Y As Single   : Y
'               Color As Long : ̐F
'***********************************************************************************
Private Sub box_x_display(ByRef pic As PictureBox, ByVal points As Integer, ByRef scl As Scale_t, _
                    ByVal p1 As Single, ByVal p2 As Single, ByVal Y As Single, Color As Long)
    Dim Grefv, Gsdiv, Grefp, StepSdiv As Single
    Dim ss As Single
    Dim Gsmax, Gsmin As Single
    Dim xx As Single
    Dim yy As Single
    Dim ViewY, ViewX, VYoff As Single
    Dim DeltX As Single
    Dim DeltY As Single
    Dim x1, x2 As Single
    
    Grefv = scl.ref
    Gsdiv = scl.div
    Grefp = scl.pos
    StepSdiv = Gsdiv / 10
    ss = Abs(100 - Grefp)
    Gsmax = Grefv + (ss * StepSdiv)
    Gsmin = Grefv - (Abs(100 - ss) * StepSdiv)
    ss = Gsmax - Gsmin
    If ss = 0 Then ss = Gsmin

    'Calculates size of scale frame
    ViewX = pic.ScaleWidth / 104
    ViewY = pic.ScaleHeight / 11
    VYoff = GRAPH_Y_POSI_OFFSET
    DeltX = (ViewX * 100) / points
    DeltY = (ViewY * 10) / ss
    
    x1 = DeltX * p1 + ViewX
    x2 = DeltX * p2 + ViewX
    
    yy = SclLim(Gsmax, Gsmin, ViewY * VYoff, DeltY, Y)
    pic.PSet (x1, yy)
    pic.Line -(x2, yy), Color

End Sub


'***********************************************************************************
' c
'     ByVal g As Graphics : Ot\ւ̃IuWFNg
'         ByRef points As Integer : |Cg
'         ByVal p1_disp As Integer : Box(x1, y) \tO
'         ByVal p2_disp As Integer : Box(x2, y) \tO
'         ByRef p1 As Integer : Box(x1, y) }[J[\ʒu|Cg
'         ByRef p2 As Integer : Box(x2, y) }[J[\ʒu|Cg
'***********************************************************************************
Private Sub box_yy_display(ByVal lngCh As Long, ByRef pic As PictureBox, ByVal points As Integer, _
                            ByRef scl As Scale_t, ByRef msi As struct_measInfo, ByVal Color As Long)
    Dim Grefv, Gsdiv, Grefp, StepSdiv As Single
    Dim ss As Single
    Dim Gsmax, Gsmin As Single
    Dim xx, Lwy, Upy As Single
    Dim ViewY, ViewX, VYoff As Single
    Dim DeltX As Single
    Dim DeltY As Single
    Dim x1, x2 As Single

    'Calculates size of scale frame
    Grefv = scl.ref
    Gsdiv = scl.div
    Grefp = scl.pos
    StepSdiv = Gsdiv / 10
    ss = Abs(100 - Grefp)
    Gsmax = Grefv + (ss * StepSdiv)
    Gsmin = Grefv - (Abs(100 - ss) * StepSdiv)
    ss = Gsmax - Gsmin
    If ss = 0 Then ss = Gsmin
    
    ViewX = pic.ScaleWidth / 104
    ViewY = pic.ScaleHeight / 11
    VYoff = GRAPH_Y_POSI_OFFSET
    DeltX = (ViewX * 100) / points
    DeltY = (ViewY * 10) / ss
    
    With msi
        If .LwLmtFrqFlg Then
            x1 = x_point_interpolation(lngCh, .PLwLmtFrq, .LwLmtFrq, BufFrq)
            x1 = DeltX * x1 + ViewX
            If .LwLmtLvlFlg And .UpLmtLvlFlg Then
                Lwy = SclLim(Gsmax, Gsmin, ViewY * VYoff, DeltY, .LwLmtLvl)
                Upy = SclLim(Gsmax, Gsmin, ViewY * VYoff, DeltY, .UpLmtLvl)
                pic.PSet (x1, Lwy)
                pic.Line -(x1, Upy), Color
            Else
                pic.PSet (x1, ViewY * VYoff)
                pic.Line -(x1, ViewY * (10 + VYoff)), Color
            End If
        End If
        
        If .UpLmtFrqFlg Then
            x2 = x_point_interpolation(lngCh, .PUpLmtFrq, .UpLmtFrq, BufFrq)
            x2 = DeltX * x2 + ViewX
            If .LwLmtLvlFlg And .UpLmtLvlFlg Then
                Lwy = SclLim(Gsmax, Gsmin, ViewY * VYoff, DeltY, .LwLmtLvl)
                Upy = SclLim(Gsmax, Gsmin, ViewY * VYoff, DeltY, .UpLmtLvl)
                pic.PSet (x2, Lwy)
                pic.Line -(x2, Upy), Color
            Else
                pic.PSet (x2, ViewY * VYoff)
                pic.Line -(x2, ViewY * (10 + VYoff)), Color
            End If
        End If
    End With
End Sub

'***********************************************************************************
' ԏiԁj
'***********************************************************************************
Private Function x_mkr_interpolation(ByVal ActCh As Long, ByRef Rectinf As struct_Rectangular_coordinate, ByVal mp As Long, ByVal mkx As Double, ByRef Refx() As Double) As Single
    Dim xx As Single
    
    With Rectinf
        If mkx <> Refx(mp, ActCh) Then
            If mp <> 0 Then
                If Refx(mp - 1, ActCh) < mkx And mkx < Refx(mp, ActCh) Then mp = mp - 1
            End If
            mkx = mp + (mkx - Refx(mp, ActCh)) * ((mp + 1) - mp) / (Refx(mp + 1, ActCh) - Refx(mp, ActCh))
            xx = .DeltX * mkx + .ViewX
        Else
            xx = .DeltX * mp + .ViewX
        End If
    End With
    
    x_mkr_interpolation = xx
End Function

'***********************************************************************************
' ԏiԁj
'***********************************************************************************
Public Function x_point_interpolation(ByVal ActCh As Long, ByVal mp As Long, ByVal mkx As Double, ByRef Refx() As Double) As Single
    Dim xx As Single
    
    If mkx <> Refx(mp, ActCh) Then
        If mp <> 0 Then
            If Refx(mp - 1, ActCh) < mkx And mkx < Refx(mp, ActCh) Then mp = mp - 1
        End If
        xx = mp + (mkx - Refx(mp, ActCh)) * ((mp + 1) - mp) / (Refx(mp + 1, ActCh) - Refx(mp, ActCh))
    Else
        xx = mp
    End If
    
    x_point_interpolation = xx
End Function


'***********************************************************************************
' }[J\
'***********************************************************************************
Private Function v_mkr_display(ByVal lngCh As Long, ByRef pic As PictureBox, ByRef Trfmt As Long, ByRef scl As Scale_t, _
                            GrphRectInf As struct_Rectangular_coordinate, ByVal measct As Long) As Long
    Dim Grefv, Gsdiv, Grefp, StepSdiv As Single
    Dim ss As Single
    Dim Gsmax, Gsmin, dt As Single
    Dim DeltY As Single
    Dim xx As Single
    Dim yy As Single
    Dim Color As Long
    Dim k As Integer
    Dim StrMeasData As String
    Dim mp As Long
    Dim strTitle As String
    Dim strUnit As String
    Dim mkr_frq As Double

    Grefv = scl.ref
    Gsdiv = scl.div
    Grefp = scl.pos
    StepSdiv = Gsdiv / 10
    ss = Abs(100 - Grefp)
    Gsmax = Grefv + (ss * StepSdiv)
    Gsmin = Grefv - (Abs(100 - ss) * StepSdiv)

    With GrphRectInf
        ss = Gsmax - Gsmin  'Calculating 
        If ss = 0 Then ss = Gsmin
        DeltY = (.ViewY * 10) / ss
        
        For measct = measct To (ChInfo(lngCh).MeasSegNum - 1) + measct  '荀ڐ
            If MeasData(measct).ResJudge = False Then
                Color = vbRed
            Else
                Color = vbCyan
            End If
            mp = MeasData(measct).freqp
            If mp >= 0 And (Trfmt And MeasData(measct).ResTrcFmt) > 0 Then
                dt = MeasData(measct).ResData
                If MeasData(measct).ResType = McrFreq Then
                    xx = x_mkr_interpolation(lngCh, GrphRectInf, mp, MeasData(measct).freq_lvl, BufFrq)
                Else
                    xx = x_mkr_interpolation(lngCh, GrphRectInf, mp, MeasData(measct).freq_lvl, BufLvl)
                End If
                yy = SclLim(Gsmax, Gsmin, .ViewY * .VYoff, DeltY, dt)
                pic.PSet (xx, yy)
                pic.Line (xx, yy)-(xx, yy - 200), Color
                pic.Line (xx, yy)-(xx - 40, yy - 100), Color
                pic.Line (xx, yy)-(xx + 40, yy - 100), Color
                Call frmCH.PicBoxTextDisp(pic, xx - 50, yy - 410, CStr(measct + 1), 10, Color)  'Marker No. display
            End If
        Next measct
    End With
    v_mkr_display = measct
End Function

'***********************************************************************************
' 茋ʕ\
'***********************************************************************************
Public Sub result_display(ByVal lngCh As Long, ByRef pic As PictureBox, ByRef measct As Long)

    Dim Y_line As Single
    Dim line_cnt As Integer
    Dim Color As Long
    Dim StrMeasData As String

    Y_line = McrDispLineOf    ' 1 Line Offset
    line_cnt = 1
    
    For measct = measct To (ChInfo(lngCh).MeasSegNum - 1) + measct  '荀ڐ
        If MeasData(measct).ResJudge = False Then
            Color = vbRed
        Else
            Color = vbWhite
        End If
        StrMeasData = MeasData(measct).strDispData
        Call frmCH.PicBoxTextDisp(pic, 100, Y_line * line_cnt + 380, StrMeasData, McrDispFontSz, Color)
        line_cnt = line_cnt + 1
    Next measct
End Sub

'***********************************************************************************
' Obh\
'***********************************************************************************
Public Sub GridDisp(ByRef pic As PictureBox, wvfmt As Long, points As Long, _
                        ByRef RectInfo As struct_Rectangular_coordinate, ByRef PolarInfo As struct_PolarCoordinates)
    If (wvfmt And (WAVE_FORMAT_LOGMAG Or WAVE_FORMAT__DELAY Or WAVE_FORMAT____SWR Or _
                                    WAVE_FORMAT___REAL Or WAVE_FORMAT___IMAG)) <> 0 Then
        '---------------------------------------------------------------
        ' LOGMAG or SWR  Grid display
        '---------------------------------------------------------------
        'Calculates size of scale fram
        With RectInfo
            .points = points
            .ViewX = pic.ScaleWidth / 104
            .ViewY = pic.ScaleHeight / 11
            .VYoff = GRAPH_Y_POSI_OFFSET
            .DeltX = (.ViewX * 100) / points
            .Color1 = COLOR_GRID_LOGMAG
            .Color2 = COLOR_BOLD_GRID_LOGMAG
        End With

        Call grid_display(pic, RectInfo)
    End If

End Sub

'***********************************************************************************
' ~bgEC\
'***********************************************************************************
Private Sub LmtLineDisp(ByVal lngCh As Long, ByRef pic As PictureBox, ByRef pt As Long, ByRef scl As Scale_t, GrphRectInf As struct_Rectangular_coordinate)
    Dim Grefv, Gsdiv, Grefp, StepSdiv As Single
    Dim DeltY As Single
    Dim x_st As Single
    Dim x_sp As Single
    Dim yy As Single
    Dim i As Integer
    Dim ss, Gsmax, Gsmin As Single
    Dim lwfrqdsp As Integer
    Dim upfrqdsp As Integer
    
    Grefv = scl.ref
    Gsdiv = scl.div
    Grefp = scl.pos
    StepSdiv = Gsdiv / 10
    ss = Abs(100 - Grefp)
    Gsmax = Grefv + (ss * StepSdiv)
    Gsmin = Grefv - (Abs(100 - ss) * StepSdiv)
    
    ss = Gsmax - Gsmin
    If ss = 0 Then ss = Gsmin
    DeltY = (GrphRectInf.ViewY * 10) / ss
    
    For i = 0 To ChInfo(lngCh).MeasSegNum
        With MeasInfo(lngCh, i)
            If .LmtDspFlg = BIS_ON Then
                If .LwLmtLvlFlg = BIS_ON Or .UpLmtLvlFlg = BIS_ON Then
                    If .MeasType <> McrMeasPWRVAL Then
                        x_st = x_point_interpolation(lngCh, .PStart, .Start, BufFrq)
                        x_sp = x_point_interpolation(lngCh, .PStop, .Stop, BufFrq)
                    Else
                        x_st = x_point_interpolation(lngCh, .PStart, .Start, BufLvl)
                        x_sp = x_st
                    End If
                    
                    If .LwLmtLvlFlg = BIS_ON Then
                        Call box_x_display(pic, pt - 1, scl, x_st, x_sp, .LwLmtLvl, vbRed)
                    End If
                    If .UpLmtLvlFlg = BIS_ON Then
                        Call box_x_display(pic, pt - 1, scl, x_st, x_sp, .UpLmtLvl, vbRed)
                    End If
                End If
                If .LwLmtFrqFlg Or .UpLmtFrqFlg Then
                    Call box_yy_display(lngCh, pic, pt - 1, scl, MeasInfo(lngCh, i), vbRed)
                End If
            End If
        End With
    Next i

End Sub
    
'***********************************************************************************
' g`\
'***********************************************************************************
Public Sub draw_waveO(ByVal lngCh As Long, _
                ByRef pic As PictureBox, _
                ByRef pt As Long, _
                ByRef lim As FreqLvl_Limit, _
                ByRef measct As Long)
    Dim points As Integer
    Dim limStLvlp As Integer
    Dim limSpLvlp As Integer
    Dim GrphRect As struct_Rectangular_coordinate
    Dim GrphPolar As struct_PolarCoordinates
    Dim TrcFmt As Long
    Dim cnt As Long
    
    points = pt - 1
    pic.Cls
    TrcFmt = ChInfo(lngCh).WaveFrmt
    
    '*** Grid # display ***
    Call GridDisp(pic, TrcFmt, pt - 1, GrphRect, GrphPolar)
    
    If (TrcFmt And WAVE_FORMAT_LOGMAG) <> 0 Then
        '*** LOGMAG  Reference mark  display ***
        GrphRect.Color1 = COLOR_REFL_LOGMAG
        Call ref_mkr_display(pic, ChInfo(lngCh).Trace.Mscl, GrphRect)   ' Lognmag
        '*** LOGMAG waveform ***
        GrphRect.Color1 = COLOR_WAVE_LOGMAG
        Call waveform_display(lngCh, pic, ChInfo(lngCh).Trace.Mscl, GrphRect, BufLgm)
        '*** Limit Line = display ***
        Call LmtLineDisp(lngCh, pic, pt, ChInfo(lngCh).Trace.Mscl, GrphRect)
    End If
    
    If (TrcFmt And WAVE_FORMAT____SWR) <> 0 Then
        '*** SWR Reference mark  display ***
        GrphRect.Color1 = COLOR_REFL___SWR
        Call ref_mkr_display(pic, ChInfo(lngCh).Trace.SWRscl, GrphRect) ' SWR
        '*** SWR waveform ***
        GrphRect.Color1 = COLOR_WAVE___SWR
        Call waveform_display(lngCh, pic, ChInfo(lngCh).Trace.SWRscl, GrphRect, BufSwr)
        '*** Limit Line = display ***
        Call LmtLineDisp(lngCh, pic, pt, ChInfo(lngCh).Trace.SWRscl, GrphRect)
    End If
    
    '*** Drawing current marker ***
    If (TrcFmt And WAVE_FORMAT_LOGMAG) <> 0 Then
        cnt = v_mkr_display(lngCh, pic, WAVE_FORMAT_LOGMAG, ChInfo(lngCh).Trace.Mscl, GrphRect, measct)
    End If
    If (TrcFmt And WAVE_FORMAT____SWR) <> 0 Then
        cnt = v_mkr_display(lngCh, pic, WAVE_FORMAT____SWR, ChInfo(lngCh).Trace.SWRscl, GrphRect, measct)
    End If
        
    measct = cnt
End Sub

